/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.message;

import filenet.sim.api.VWScenarioValidationError;
import filenet.sim.toolkit.designer.message.VWSIMValidationToolTip;
import filenet.sim.toolkit.designer.message.images.VWSIMImageLoader;
import filenet.vw.base.VWDebug;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class VWSIMValidationMessageTypeTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private ImageIcon m_scenarioIcon = null;
    private ImageIcon m_workflowIcon = null;

    public VWSIMValidationMessageTypeTableCellRenderer() {
        try {
            this.setOpaque(true);
            this.m_scenarioIcon = VWSIMImageLoader.createImageIcon("scenario.gif");
            this.m_workflowIcon = VWSIMImageLoader.createImageIcon("workflow.gif");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ImageIcon icon = null;
        VWScenarioValidationError error = (VWScenarioValidationError)value;
        if (error != null) {
            switch (error.getErrorType()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    icon = this.m_scenarioIcon;
                    break;
                }
                default: {
                    icon = this.m_workflowIcon;
                }
            }
        }
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        this.setIcon(icon);
        this.setText(null);
        this.setToolTipText(VWSIMValidationToolTip.createValidationToolTip(error));
        this.setComponentOrientation(table.getComponentOrientation());
        return this;
    }
}

